const express = require("express");
const router = express.Router();
const db = require("../../utils/db");
const moment = require("moment");
const { verifyToken, verifyTokenAndAdmin } = require("../middleware/verifyToken");

// router.get("/attendanceHistory", verifyToken, async (req, res) => {
router.get("/attendanceHistory", async (req, res) => {
  const userId = req.query?.userId;
  await db.getConnection(async (err, connection) => {
    if (err) {
      console.log("database not connected error: >>>", err);
      throw err;
    }

    const query = `select a.id,u.username,u.email,a.date,a.shift,a.punchIn,a.punchOut,a.duration,a.deviceName from attendance as a inner join Users as u on a.userId=u.id where u.id=${userId} ORDER BY id DESC`

    await connection.query(query, (err, attendanceData) => {
      connection.release();
      if (err) {
        console.log("error from GetShift  >>>", err);
        res.status(404).send({
          message: ("error from GetShift  >>>", err),
        });
      } else {
        res.status(208).send({
            message: "Success",
            data: attendanceData,
        });
      }
    });
  });
});

// router.get("/getattendance", verifyTokenAndAdmin, async (req, res) => {
router.get("/getattendance", async (req, res) => {
  await db.getConnection(async (err, connection) => {
    if (err) {
      console.log("database not connected error: >>>", err);
      throw err;
    }

    const query = `select a.id,u.username,u.email,a.date,a.shift,a.punchIn,a.punchOut,a.duration,a.deviceName from attendance as a inner join Users as u on a.userId=u.id ORDER BY id DESC`

    await connection.query(query, (err, attendanceData) => {
      connection.release();
      if (err) {
        console.log("error from GetShift  >>>", err);
        res.status(404).send({
          message: ("error from GetShift  >>>", err),
        });
      } else {
        res.status(208).send({
            message: "Success",
            data: attendanceData,
        });
      }
    });
  });
});

module.exports = router;
