const express = require("express");
const router = express.Router();
const db = require("../../utils/db");

const path = require("path");
const multer = require("multer");
const fs = require("fs");
const { verifyTokenAndAuthorization } = require("../middleware/verifyToken");

const storage = multer.diskStorage({
  // https://www.npmjs.com/package/multer#diskstorage
  destination: "public/uploads",
  filename: function (req, file, cb) {
    cb(null, `image-${new Date().getTime()}.${file.mimetype.split("/")[1]}`);
  },
});
var upload = multer({ storage: storage });

router.post(
  "/uploadImage",
  verifyTokenAndAuthorization,
  upload.any("image"),
  (req, res, next) => {
    console.log("req body ===>", req.body);
    const url = req.protocol + "://" + req.get("host");
    console.log("url ===>", url);
    const image = url + "/uploads/" + req.files[0].filename;
    console.log("image path ==>", image);
    const id = req.body.id;
    console.log("id  ==>", id);

    db.getConnection((err, connection) => {
      if (err) {
        console.log("database not connected error: >>>", err);
        // throw err;
      }

      const query = `UPDATE users SET
          profileUrl="${image}"
          WHERE id=${id}`;

      connection.query(query, (err, data) => {
        connection.release();
        if (err) {
          console.log(err);
          res.status(401).json({
            message:
              "error! User cant be Updated proflie picture for somereason",
            results: "Failed",
          });
        } else {
          res.status(200).json({
            message: "User profile pic uploaded Successfully",
            results: "Success",
            data: data,
          });
        }
      });
    });
  }
);

router.post("/updateUser", verifyTokenAndAuthorization, (req, res) => {
  // router.post("/updateUser",(req, res) => {
  console.log("req.body >>>>", req.body);
  const id = req.body.id;
  const username = req.body.username;
  const avatar = req.body.avatar;
  // const email = req.body.email;
  // const password = req.body.password;
  // const userRole = req.body.userRole;

  var query = "";
  if (username && avatar) {
    query = `UPDATE Users SET 
    username="${username}", 
    avatar="${avatar}"
    WHERE id=${id}`;
  } else if (username) {
    query = `UPDATE Users SET 
    username="${username}"
    WHERE id=${id}`;
  } else {
    query = `UPDATE Users SET 
    avatar="${avatar}"
    WHERE id=${id}`;
  }
  // email='${email}',
  // userRole='${userRole}'
  // password='${password}',

  db.getConnection((err, connection) => {
    if (err) {
      console.log("database not connected error: >>>", err);
      throw err;
    }

    connection.query(query, (err, data) => {
      connection.release();
      if (err) {
        console.log("error from update users ==>", err);
        if (err.code === "ER_DUP_ENTRY") {
          res.status(409).json({
            message: "Duplicate User",
            results: "Failed",
          });
        } else if (err.code === "ENOTFOUND") {
          res.status(404).json({
            message: "Internet Connection Failed",
            results: "Failed",
          });
        } else {
          res.status(500).json({
            message: "Error from server",
          });
        }
      } else {
        res.status(200).json({
          message: "Updated Successfully",
          results: data,
        });
      }
    });
  });
});

module.exports = router;
