const express = require("express");
const router = express.Router();
const db = require("../../utils/db");
const { verifyToken } = require("../middleware/verifyToken");

router.get("/getLine", verifyToken, (req, res) => {
  // router.get("/getLine", (req, res) => {
  const id = req.body.id;

  db.getConnection((err, connection) => {
    if (err) {
      console.log("database not connected error: >>>", err);
      // throw err;
      return res.send(err)
    }
    const query = `SELECT CASE WHEN a.userId IS NOT NULL THEN a.userId ELSE 0 END AS userId,l.id,l.deviceName,u.username FROM (select deviceName,userid,punchOut from attendance where punchOut is null) AS a Right JOIN LineDetails AS l ON a.deviceName = l.deviceName left join Users as u on u.id=a.userid`;
    connection.query(query, (err, data) => {
      connection.release();
      if (err) {
        console.log("error from select LineDetails >>>", err);
        if (err.code === "ENOTFOUND") {
          return res.status(404).json({
            message: "Internet Connection Failed",
            results: "Failed",
          });
        } else {
          return res.status(401).json({
            message: "creation failed",
            results: "Failed",
          });
        }
      } else {
        // console.log("data from select LineDetails >>>", data);
        return res.status(200).send({
          message: `Select successfully`,
          data: data,
        });
      }
    });
  });
});

module.exports = router;
