const express = require("express");
const router = express.Router();
const db = require("../../utils/db");
const moment = require("moment");
const {
  verifyTokenAndAdmin,
  verifyToken,
} = require("../middleware/verifyToken");
const { forEach, min, max } = require("lodash");

router.get("/getStops", verifyToken, (req, res) => {
  const id = req.body.id;
  const deviceName = req.query?.deviceName;

  db.getConnection((err, connection) => {
    if (err) {
      console.log("database not connected error: >>>", err);
      throw err;
    }
    const query = deviceName
      ? `SELECT * FROM Stops WHERE deviceName="${deviceName}" order by id DESC  LIMIT 50`
      : `SELECT * FROM Stops order by id DESC  LIMIT 50`;
    connection.query(query, (err, data) => {
      connection.release();
      if (err) {
        console.log("error from select Stops >>>", err);
        res.status(401).send({
          message: `selected error`,
          error: err,
        });
      } else {
        // console.log("data from select Stops >>>", data);
        res.status(200).send({
          message: `selected Successfully`,
          data: data,
        });
      }
    });
  });
});

// router.get("/getStopsByMachineAndStartTime", verifyToken, (req, res) => {
router.get("/getStopsByMachineAndStartTime", (req, res) => {
  const deviceName = req.query.deviceName;
  const orderStart = req.query.plannedStart;

  db.getConnection((err, connection) => {
    if (err) {
      console.log("database not connected error: >>>", err);
      throw err;
    }
    const query = `SELECT * FROM Stops WHERE deviceName="${deviceName}" AND orderStart="${orderStart}" ORDER BY startTime DESC`;
    console.log(`Select Query >>> ${query}`);
    connection.query(query, (err, data) => {
      connection.release();
      if (err) {
        console.log("error from select Stops >>>", err);
        res.status(401).send({
          message: `selected error`,
          error: err,
        });
      } else {
        console.log(`Stops Data >>> ${data}`);
        res.status(200).send({
          message: `selected Successfully`,
          data: data,
        });
      }
    });
  });
});

router.post("/getStopsByDate", verifyToken, (req, res) => {
  const startDate = req.body.startDate;
  const endDate = req.body.endDate;
  console.log("startDate >>>", startDate);
  console.log("endDate >>>", endDate);

  if (startDate === endDate) {
    console.log("both equal >>>");

    db.getConnection((err, connection) => {
      if (err) {
        console.log("database not connected error: >>>", err);
        throw err;
      }
      const selectStopsByDateEqual = `select * from Stops WHERE orderStart > '${startDate} 07:00:00' AND orderStart<'${endDate} 23:00:00'`;
      connection.query(selectStopsByDateEqual, (err, result) => {
        connection.release();
        if (err) {
          res.status(500).send({
            message: "Some error in order selection",
            data: [],
          });
        } else {
          res.status(200).send({
            message: "Stops selected Successfully",
            data: result,
          });
        }
      });
    });
  } else {
    db.getConnection((err, connection) => {
      if (err) {
        console.log("database not connected error: >>>", err);
        throw err;
      }

      const selectStopsByDate = `select * from Stops WHERE (orderStart > '${startDate} 07:00:00' AND orderStart<'${endDate} 07:00:00')  ORDER BY id DESC`;
      console.log("selectStopsByDate >>>", selectStopsByDate);
      connection.query(selectStopsByDate, (err, result) => {
        connection.release();
        if (err) {
          res.status(500).send({
            message: "Some error in order selection",
            data: [],
          });
        } else {
          res.status(200).send({
            message: "Stops selected Successfully",
            data: result,
          });
        }
      });
    });
  }
});

// router.get("/getStopsBytimestamp", verifyToken, (req, res) => {
router.post("/getStopsBytimestamp", (req, res) => {
  const deviceName = req.body.deviceName;
  const timestamp = req.body.timestamp;
  console.log("deviceName >>>", deviceName);
  console.log("timestamp >>>", timestamp);

  db.getConnection((err, connection) => {
    if (err) {
      console.log("database not connected error: >>>", err);
      throw err;
    }
    const selectStopsBytimestamp = `SELECT * FROM Stops WHERE deviceName="${deviceName}" AND STR_TO_DATE(startTime, '%Y-%m-%dT%T') <= STR_TO_DATE('${timestamp}', '%m/%d/%Y %H:%i:%s') AND STR_TO_DATE(endTime, '%Y-%m-%dT%T') >= STR_TO_DATE('${timestamp}', '%m/%d/%Y %H:%i:%s');`;

    console.log("selectStopsBytimestamp >>> ", selectStopsBytimestamp);
    connection.query(selectStopsBytimestamp, (err, stopByTimestamp) => {
      if (err) {
        connection.release();
        res.status(500).send({
          message: "Some error in order selection",
          data: [],
        });
      } else {
        var selectStopsid = ``;
        if (stopByTimestamp?.length > 0) {
          if (stopByTimestamp[0]?.mainStopId > 0) {
            selectStopsid = `SELECT * FROM Stops where id= '${stopByTimestamp[0]?.mainStopId}' or mainStopId = '${stopByTimestamp[0]?.mainStopId}';`;
          } else {
            selectStopsid = `SELECT * FROM Stops where id= '${stopByTimestamp[0]?.id}' or mainStopId = '${stopByTimestamp[0]?.id}';`;
          }
          connection.query(selectStopsid, (err, result) => {
            connection.release();
            if (err) {
              res.status(500).send({
                message: "Some error in order selection",
                data: [],
              });
            } else {
              res.status(200).send({
                message: "Stops selected Successfully",
                data: result,
              });
            }
          });
        }
      }
    });
  });
});

router.get("/getUnReportedStops", (req, res) => {
  const deviceName = req.query.deviceName;
  const category = "0";
  const orderId = parseInt(req.query.orderId);
  const shiftName = req.query.shiftName;

  db.getConnection((err, connection) => {
    if (err) {
      console.log("database not connected error: >>>", err);
      throw err;
    }
    const query = `SELECT * FROM Stops WHERE deviceName="${deviceName}" AND orderId=${orderId} AND categoryName="${category}" AND shiftName="${shiftName}"`;

    connection.query(query, (err, result) => {
      if (err) {
        connection.release();
        res.status(500).send({
          message: "Some error in order selection",
          data: [],
        });
      } else {
        res.status(200).send({
          message: "Unreported Stops selected Successfully",
          data: result,
        });
      }
    });
  });
});

module.exports = router;
